let tasks = [];
let nextId = 1;

function getAllTasks() {
    return tasks;
}

function getTaskById(id) {
    return tasks.find(t => t.id === id);
}

function createTask({ title, description, status, dueDate }) {
    const task = {
        id: nextId++,
        title,
        description,
        status: status || "pending",
        dueDate: dueDate || ""
    };

    tasks.push(task);
    return task;
}

function updateTask(id, newValues) {
    const index = tasks.findIndex(t => t.id === id);

    if (index === -1) return null;

    tasks[index] = { id, ...newValues };
    return tasks[index];
}

function deleteTask(id) {
    const index = tasks.findIndex(t => t.id === id);

    if (index === -1) return null;

    return tasks.splice(index, 1);
}

module.exports = {
    getAllTasks,
    getTaskById,
    createTask,
    updateTask,
    deleteTask
};
